package com.youqian.api.enums.raffle;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/7/7.
 */
@Getter
public enum RaffleStatusEnum {

    LOTTERY_IN_PROGRESS((byte)0,"lotteryInProgress","开奖中"),
    LOTTERY((byte)1,"lottery","已开奖"),
    CANCELLED((byte)2,"cancelled","已取消");

    private final Byte code;

    private final String type;

    private final String desc;

    RaffleStatusEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static RaffleStatusEnum getByCode(Byte code) {
        return Stream.of(RaffleStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(LOTTERY);
    }

    public static RaffleStatusEnum getByType(String type) {
        return Stream.of(RaffleStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(LOTTERY);
    }
}

