package com.youqian.api.params.goods;

import com.youqian.api.params.goods.spec.AddSkuSpecParamV1;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
public class AddSkuParam implements Serializable {

    private static final long serialVersionUID = -212636563529206686L;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 件规
     */
    private Integer totalSpec;

    /**
     * 是否选中
     */
    private Boolean selected;

    /**
     * 规格集合
     */
    private List<AddSkuSpecParamV1> specs;

}
