package com.youqian.api.params.goods;

import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/24.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GoodsListGetParamV2 extends PageParam implements Serializable {

    private static final long serialVersionUID = 7459639963746710444L;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 商品名称
     */
    private String     name;

    /**
     * 商品货号（短名称）
     */
    private String     shortName;

    /**
     * 上新
     */
    private Byte    newPublish;

    /**
     * 爆款
     */
    private Byte    hot;

    /**
     * 促销
     */
    private Byte    discount;

    /**
     * 商品id集合
     */
    private List<Long> goodsIds;

    /**
     * 商户id
     */
    private Long merchantId;
}
