package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/14
 * @description
 */
@Data
@NoArgsConstructor
public class GoodsRequest implements Serializable {

    @Min(value = 1, message = "商品ID必须大于0")
    @NotNull(message = "商品ID不能为空")
    @ApiModelProperty(value = "商品ID", required = true)
    private Long goodsId;

    @NotBlank(message = "商品名称不能为空")
    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @NotBlank(message = "商品款号不能为空")
    @ApiModelProperty(value = "商品款号", required = true)
    private String shortName;

//    @NotBlank(message = "商品单位不能为空")
    @ApiModelProperty(value = "单位", required = true)
    private String unit;

//    @NotNull(message = "商品单价不能为空")
    @ApiModelProperty(value = "商品单价", required = true)
    private BigDecimal price;

    @Valid
    @Size(min = 1, message = "商品规格不能为空")
    @NotNull(message = "商品规格不能为空")
    @ApiModelProperty(value = "规格详情", required = true)
    private List<OrderItemRequest> skuList;

}
