package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/4/2
 * @description
 */
@Data
@NoArgsConstructor
public class OrderItemRequest implements Serializable {

    @Min(value = 1, message = "skuId必须大于0")
    @NotNull(message = "skuId不能为空")
    @ApiModelProperty(value = "规格ID", required = true)
    private Long skuId;

    @ApiModelProperty(value = "数量", required = true)
    private Integer num;

    @NotNull(message = "商品单价不能为空")
    @ApiModelProperty(value = "单价", required = true)
    private BigDecimal price;

    @NotBlank(message = "skuName不能为空")
    @ApiModelProperty(value = "sku名称", required = true)
    private String skuName;

//    @NotBlank(message = "货号不能为空")
    @ApiModelProperty(value = "货号")
    private String sn;

}
