package com.youqian.api.dto;

import com.jiamai.live.api.dto.live.LiveRoomDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 客户申请结果dto
 * Created by hong
 * time 2020/5/27.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CustomerApplyResultDto {
    /**
     * 申请状态  （申请观看直播）3-未处理/2-已同意/1-已拒绝/0未申请
     */
    private Byte applicationStatus;

    /**
     * 申请直播间id
     */
    private Long applyLiveId;

    /**
     * 商户名称
     * max length = 20
     * not null default =
     */
    private String merchantName;

    /**
     * 商户LOGO
     * max length = 100
     * not null default =
     */
    private String logo;


    /**
     * 申请理由
     */
    private String applyReason;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间dto
     */
    private LiveRoomDto liveRoomDto;

    /**
     * 直播间申请模板ID
     */
    private List<String> applyTemplateIds;
}
