package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 访问动作拓展
 * @author youqian mybatis generator 
 * 2020-04-23
 */
@Data
public class AccessLogExtDto implements Serializable {
    private static final long serialVersionUID = 15876180177411386L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    private Long wxSubOpenId;

    /**
     * 日志拓展的ID
     * not null default = 0
     */
    private Long accessLogExtId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户名字
     */
    private String userName;

    /**
     * 用户头像
     */
    private String avatarUrl;

    /**
     * 用户手机号
     */
    private String mobile;

    /**
     * 动作类型
     * not null default = 0
     */
    private Byte type;

    /**
     * 动作前缀:关键字
     */
    private String prefixTypeName;

    /**
     * 动作后缀
     */
    private String suffixTypeName;

    /**
     * 商品图片
     */
    private String picUrl;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 时间格式
     */
    private String time;

    /**
     * 直播间ID
     * not null default = null
     */
    private Long liveRoomId;

    /**
     * 商品ID
     * not null default = null
     */
    private Long goodsId;

    /**
     * 商品名字
     */
    private String goodsName;

    /**
     * 分享的用户Id
     */
    private Long shareUserId;

    /**
     * 日志ID
     * not null default = 0
     */
    private Long accessLogId;

    /**
     * 0-直播间 1-店铺
     * not null default = 1
     */
    private Byte channel;

    /**
     * 深度线索标签
     * not null default = 0
     */
    private Byte tag;

    /**
     * 标签名
     */
    private String tagName;

    /**
     * 线索文案
     */
    private String tagMessage;

    /**
     * 来源
     */
    private Byte source;
}