package com.youqian.api.dto.redpack.custom;

import com.youqian.api.dto.redpack.RedpackDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 红包打款处理失败
 * Created by hong
 * time 2020/9/18.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WithdrawFailureDto implements Serializable {

    private static final long serialVersionUID = 2602868766282025352L;

    /**
     * 打款金额
     */
    private BigDecimal amount;

    /**
     * 红包
     */
    private RedpackDto redpackDto;

    /**
     * 直播名称
     */
    private String liveRoomName;

    /**
     * 红包账单id
     */
    private Long RedpackBillId;

    /**
     * 红包参与id
     */
    private Long redpackParticipationId;

    /**
     * 钱包id
     */
    private Long WalletId;

    /**
     * 钱包账单id
     */
    private Long WalletBillId;

    /**
     * 打款失败流水号
     */
    private String partnerTradeNo;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误说明
     */
    private String errCodeDes;

    /**
     * 错误说明
     */
    private Long userId;

    /**
     * 重试次数
     */
    private Integer retry;
}
