package com.youqian.api.dto.reportmain;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 报价商品规格表
 * @author youqian mybatis generator 
 * 2020-06-09
 */
@Data
public class OrderDunningBillRDto implements Serializable {
    private static final long serialVersionUID = 1591688119122392L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 报价ID
     * not null default = 0
     */
    private Long orderReportBillExtId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户Id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 报单ID
     * not null default = 0
     */
    private Long goodsReportBillId;

    /**
     * 商户规格ID
     * not null default = 0
     */
    private Long shopGoodsSpecId;

    /**
     * 数量
     * not null default = 0
     */
    private Integer goodsNum;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}