package com.youqian.api.dto.shopgoods.custom;

import com.youqian.api.dto.PageDto;
import com.youqian.api.dto.shopgoods.ShopGoodsDto;
import com.youqian.api.dto.shopgoods.ShopGoodsTagDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商品和标签分页数据汇总
 * Created by hong
 * time 2020/4/21.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class GoodsTagDto extends ShopGoodsDto {

    private static final long serialVersionUID = 5711221765834102966L;

    /**
     * 标签列表
     */
    private List<ShopGoodsTagDto> tags;

    /**
     * 商品属性文案
     */
    private String attributeText;
}
