package com.youqian.api.dto.statistics.platform;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 平台统计表
 * @author youqian mybatis generator 
 * 2020-11-19
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PlatformStatisticsDto implements Serializable {
    private static final long serialVersionUID = 16057892288389555L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long platformStatisticsId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 新增商户数
     * not null default = 0
     */
    private Long newMerchants;

    /**
     * 新增用户数
     * not null default = 0
     */
    private Long newUsers;

    /**
     * 用户数
     * not null default = 0
     */
    private Long userCount;

    /**
     * 新增卖家数
     * not null default = 0
     */
    private Long newSellers;

    /**
     * 新增客户数
     * not null default = 0
     */
    private Long newCustomers;

    /**
     * 客户总数
     * not null default = 0
     */
    private Long customerCount;

    /**
     * 平台访问量
     * not null default = 0
     */
    private Long platformViews;

    /**
     * 访客数
     * not null default = 0
     */
    private Long visitorCount;

    /**
     * 活跃卖家
     * not null default = 0
     */
    private Long activeSeller;

    /**
     * 活跃买家
     * not null default = 0
     */
    private Long activeCustomer;

    /**
     * 已播直播场数
     * not null default = 0
     */
    private Long playedLive;

    /**
     * 待播放直播场数
     * not null default = 0
     */
    private Long toBePlayedLive;

    /**
     * 新增商品数
     * not null default = 0
     */
    private Long newGoods;

    /**
     * 新增订单数
     * not null default = 0
     */
    private Long newOrders;

    /**
     * 商品数
     * not null default = 0
     */
    private Long goodsCount;

    /**
     * 订单数
     * not null default = 0
     */
    private Long orderCount;

    /**
     * 开单金额
     * not null default = 0.0000
     */
    private BigDecimal billedAmount;

    /**
     * 邀约人数
     * not null default = 0
     */
    private Long invitationCount;

    /**
     * 到场人数
     * not null default = 0
     */
    private Long liveWatches;

    /**
     * 直播时长
     * not null default = 0
     */
    private Long liveDuration;

    /**
     * 人均观看时长
     * not null default = 0
     */
    private Long liveCapitaViewingTime;

    /**
     * 统计年份
只有年份 统计的是该年份的数据
只有年份和周数 统计的是该年该周的数据
只有年份和月份 统计的是该年该月的数据
有年月日 统计的是当天的数据
     */
    private Integer statisticsYear;

    /**
     * 统计月份
     */
    private Integer statisticsMonth;

    /**
     * 统计日期
     */
    private Integer statisticsDay;

    /**
     * 统计周数
     */
    private Integer statisticsWeek;
}