package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 邀约来源
 * @author xiachenhang
 */
@Getter
public enum SourceTypeEnum {
    UN_KNOW((byte)0,"",""),
    POSTER((byte)1,"来自海报","海报"),
    CARD((byte)2,"来自卡片","卡片"),
    STORE((byte)3,"来自店铺","店铺"),
    PRE((byte)4,"来自上场直播","上场直播"),
    ;

    private Byte source;
    private String msg;
    private String channel;

    SourceTypeEnum(Byte source,String msg,String channel){
        this.msg = msg;
        this.source = source;
        this.channel = channel;
    }

    public static SourceTypeEnum get(Byte code){
        for(SourceTypeEnum sourceTypeEnum:values()){
            if(Objects.equals(sourceTypeEnum.getSource(),code)){
                return sourceTypeEnum;
            }
        }
        return UN_KNOW;
    }
}
