package com.youqian.api.enums.wx;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/4/25.
 */
@Getter
public enum CustomerMessageTypeEnum {

    TEXT_KEFU(1,"textKefu","客服文字消息");

    private final Integer code;

    private final String type;

    private final String desc;

    CustomerMessageTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CustomerMessageTypeEnum getByCode(Integer code) {
        return Stream.of(CustomerMessageTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(TEXT_KEFU);
    }

    public static CustomerMessageTypeEnum getByType(String type) {
        return Stream.of(CustomerMessageTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(TEXT_KEFU);
    }
}

