package com.youqian.api.params;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 添加红包参数
 * Created by hong
 * time 2020/7/16.
 */
@Data
public class AddRedpackParam {

    /**
     * 是否随机金额
     * not null default = null
     */
    private Byte randomAmount;

    /**
     * 是否关注后参与
     * not null default = 0
     */
    private Byte followAfterRaffle;

    /**
     * 红包名
     * max length = 30
     * not null default = null
     */
    private String name;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 红包个数
     * not null default = 0
     */
    private Integer total;

    /**
     * 发红包时间 （几分钟后）
     */
    private Integer sendAfterMinutes;
}

