package com.youqian.api.params.statistics;

import lombok.Data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by hong
 * time 2020/11/20.
 */
@Data
public class ChartStatisticsParam implements Serializable {

    private static final long serialVersionUID = -295419898795217223L;

    /**
     * 年份
     */
    private Integer years=getYear(new Date());

    /**
     * 月份
     */
    private Integer month;

    /**
     * 商户id
     */
    private Long merchantId =0L;

    private int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }
}
