package com.youqian.api.params.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * Created by hong
 * time 2020/11/17.
 */
@Data
public class PlatformStatisticsParam implements Serializable {

    private static final long serialVersionUID = 8922706664161803713L;

    /**
     * 时间
     * 1 今天
     * 2 昨天
     * 3 本周
     * 4 本月
     */
    private Integer queryTimeType;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 年份
     */
    @Deprecated
    private Integer year;

    /**
     * 月份
     */
    @Deprecated
    private Integer month;

    /**
     * 日期
     */
    @Deprecated
    private Integer day;

    /**
     * 第几周
     */
    @Deprecated
    private Integer week;

    public void setQueryTimeType(Integer queryTimeType) {
        Date date = new Date();
        if(Objects.equals(4,queryTimeType)){
            this.year= getYear(date);
            this.month = getMonth(date);
            this.queryTimeType = queryTimeType;
        }else if(Objects.equals(2,queryTimeType)){
            this.year= getYear(DateUtils.daysAddOrSub(date,-1));
            this.month = getMonth(DateUtils.daysAddOrSub(date,-1));
            this.day=getDay(DateUtils.daysAddOrSub(date,-1));
            this.week=getWeek(DateUtils.daysAddOrSub(date,-1));
            this.queryTimeType = queryTimeType;
        }else if(Objects.equals(3,queryTimeType)){
            this.year= getYear(date);
            this.week=getWeek(date);
            this.queryTimeType = queryTimeType;
        }else {
            this.year= getYear(date);
            this.month = getMonth(date);
            this.day=getDay(date);
            this.week=getWeek(date);
            this.queryTimeType = queryTimeType;
        }
    }

    private int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }

    private int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.MONTH);
    }

    private int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.DAY_OF_MONTH);
    }

    private int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.WEEK_OF_YEAR);
    }
}
