package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.OrderCustomerStatisticsRequest;
import com.youqian.api.request.OrderEmpStatisticsRequest;
import com.youqian.api.request.OrderSkuStatisticsRequest;
import com.youqian.api.dto.order.OrderMainDto;
import com.youqian.api.request.OrderListRequest;
import com.youqian.api.request.OrderStatisticsRangeRequest;
import com.youqian.api.request.OrderStatisticsRequest;
import com.youqian.api.response.OrderCustomerStatisticsResult;
import com.youqian.api.request.OrderSearchRequest;
import com.youqian.api.response.OrderDetail;
import com.youqian.api.response.OrderEmpStatisticsResult;
import com.youqian.api.response.OrderMainListResult;
import com.youqian.api.response.OrderSkuStatisticsResult;
import com.youqian.api.response.OrderStatisticsRangeResult;
import com.youqian.api.response.OrderStatisticsResult;
import com.youqian.api.response.OrderPageResult;
import com.youqian.api.response.PageResult;
import com.youqian.auth.api.exception.BizException;

import java.time.LocalDate;
import java.util.List;

/**
 * Created by hong
 * time 2020/5/11.
 */
@AdvancedFeignClient
public interface RemoteOrderService {
    /**
     * 查询订单列表-后台管理
     */
    List<OrderMainListResult> orderList(OrderListRequest orderListRequest) throws BizException;
    /**
     * 订单统计-后台管理
     */
    Integer orderCount(OrderListRequest orderListRequest) throws BizException;

    /**
     * 订单详情-后台管理
     */
    @Deprecated
    OrderDetail getOrderDetail(Long orderId) throws BizException;

    /**
     * 订单详情-后台管理
     * @param orderId 订单ID
     */
    OrderDetail orderDetail(Long orderId) throws BizException;

    /**
     * 订单搜索
     *
     * @param orderSearchRequest orderSearchRequest
     * @return PageResult<OrderPageResult>
     */
    PageResult<OrderPageResult> orderPage(OrderSearchRequest orderSearchRequest) throws BizException;

    /**
     * 根据ID更新非空字段
     *
     * @param orderMainDto orderMainDto
     * @throws BizException BizException
     */
    void update(OrderMainDto orderMainDto) throws BizException;

    /**
     * 订单统计基础数据
     */
    OrderStatisticsResult orderStatistics(OrderStatisticsRequest request) throws BizException;

    /**
     * 订单统计基础数据范围
     */
    OrderStatisticsRangeResult orderStatisticsRange(OrderStatisticsRangeRequest request) throws BizException;

    /**
     * 订单员工统计
     */
    List<OrderEmpStatisticsResult> orderEmpStatistics(OrderEmpStatisticsRequest request) throws BizException;

    /**
     * 订单客户统计
     */
    List<OrderCustomerStatisticsResult> orderCustomerStatistics(OrderCustomerStatisticsRequest request) throws BizException;

    /**
     * 订单商品统计
     */
    List<OrderSkuStatisticsResult> orderSkuStatistics(OrderSkuStatisticsRequest request) throws BizException;

    /**
     * 订单T+1统计
     */
    void orderStatisticsJob(LocalDate localDate) throws BizException;
}
