package com.youqian.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 添加商户
 * @author xiachenhang
 */
@Data
public class AddMerchantRequest implements Serializable {
    private static final long serialVersionUID = -8037044879975439820L;
    /**
     * 商户名称
     */
    private String merchantName;
    /**
     * 商户简称
     */
    private String merchantNickName;
    /**
     * 省编号
     */
    private String provinceCode;
    /**
     * 市编号
     */
    private String cityCode;
    /**
     * 区编号
     */
    private String areaCode;
    /**
     * 名称
     */
    private String name;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 状态
     */
    private Byte status;

    /**
     * 页面模板类别id
     * not null default = 0
     */
    private Long pageCategoryId;

    /**
     * 商品类别 1：一元商品  2：二元商品
     * not null default = 0
     */
    private Integer goodsType;
}
