package com.youqian.api.request;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.youqian.api.util.BigDecimalDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 创建订单请求参数
 *
 * @author tengtuox
 * @date 2020/4/2
 * @description
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class CreateOrderRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "客户ID", required = true)
    private Long customerId;

    @Valid
    @Size(min = 1)
    @NotNull
    @ApiModelProperty(value = "商品详情", required = true)
    private List<GoodsRequest> goodsList;

    @ApiModelProperty(value = "运费")
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal transportFee = BigDecimal.ZERO;

    @NotNull(message = "运输方式不能为空")
    @Max(value = 3, message = "运输方式必须为1-3")
    @Min(value = 1, message = "运输方式必须为1-3")
    @ApiModelProperty(value = "运输方式， 1-卖家送货/2-买家自提/3-物流运输", required = true)
    private Byte transType;

    @ApiModelProperty(value = "交货地址（买家自提情况下必填）")
    private String deliveryAddress;

    @ApiModelProperty("收货人名称")
    private String receiverName;

    @ApiModelProperty("收货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("收货地址")
    private String receiverAddress;

    @ApiModelProperty(value = "商品最终价格")
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal orderPrice;

    @ApiModelProperty("运费支付方式,1-预付/2-包邮/3-到付")
    private Byte transportFeeType;

    @ApiModelProperty("订单备注")
    private String orderRemark;

    @ApiModelProperty("省代码")
    private String provinceCode;

    @ApiModelProperty("市代码")
    private String cityCode;

    @ApiModelProperty("区代码")
    private String areaCode;

    @ApiModelProperty("详细地址")
    private String detailArea;
}
