package com.youqian.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderMoneyBackRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @ApiModelProperty(value = "收款金额,forceEndMoney=false情况下必填", required = true)
    private BigDecimal moneyBack;

    @ApiModelProperty("收款事件（不传即为今天）, 格式yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date eventTime;

    @ApiModelProperty(value = "收款方式,1-银行卡/2-支付包/3-微信/4-现金/5-其他方式,forceEndMoney=false情况下必填", required = true)
    private Byte payWay;

    @ApiModelProperty(value = "是否结束收款流程", required = true)
    private Boolean forceEndMoney = Boolean.FALSE;
}
