package com.youqian.api.request;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class UpdateEmployeeRequest {
    /**
     * 名字
     */
    @NotNull(message = "请输入姓名")
    @Size(max = 10, min = 2, message = "请输入正确的名字")
    private String name;
    /**
     * 手机号
     */
    @NotNull(message = "请输入手机号")
    @Size(max = 11, min = 11, message = "请输入正确手机号")
    private String mobile;
    /**
     * 成员Id
     */
    @NotNull(message = "成员ID不能为空")
    @Min(1)
    private Long employeeId;
    /**
     * 角色ID
     */
    private Byte roleId;
    /**
     * 操作人ID(前端忽略)
     */
    private Long userId;
}
