package com.youqian.api.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单报表详情
 * @author xiachenhang
 */
@Data
public class OrderBillReportResult {

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("商户logo")
    private String logo;

    @ApiModelProperty("客户名称")
    private String userName;

    @ApiModelProperty("客户头像")
    private String userAvatar;

    @ApiModelProperty("客户公司")
    private String enterpriseName;

    @ApiModelProperty("客户手机号")
    private String mobile;

    @ApiModelProperty("操作人名字")
    private String operatorName;

    @ApiModelProperty("操作人手机号")
    private String operatorMobile;

    @ApiModelProperty("订货单状态")
    private Byte status;

    @ApiModelProperty("订货单状态文案")
    private String statusName;

    @ApiModelProperty("商品总件数")
    private Integer goodsTotalNum;

    @ApiModelProperty("商品总款数")
    private Integer goodsTotalCount;

    @ApiModelProperty("商品总价")
    private String goodsTotalPrice;

    @ApiModelProperty("商品列表")
    private List<OrderBillGoodsResult> orderBillGoodsResultList;

    @ApiModelProperty("查看时间")
    private Date watchTime;

    @ApiModelProperty("收货地址")
    private UserAddressResult userAddressResult;

    @ApiModelProperty("模板ID")
    private String templateId;

}
