package com.youqian.api.response;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 红包参与vo
 * Created by hong
 * time 2020/7/16.
 */
@Data
public class RedpackParticipation1Vo {
    /**
     * 唯一id
     * not null default = null
     */
    private Long redpackParticipationId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 抢红包用户
     * not null default = 0
     */
    private Long userId;

    /**
     * 参与红包id
     * not null default = 0
     */
    private Long redpackId;

    /**
     * 抢到红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 抢红包时间
     */
    private Date grabDate;

    /**
     * 版本控制，扩展乐观锁使用
     * not null default = 0
     */
    private Integer participationVersion;

    /**
     * 领取状态：1-未领取，2-领取中，3-领取成功，4-领取失败
     * not null default = null
     */
    private Byte receiveStatus;

    /**
     * 领取类型：1-普通红包，2-手气王
     * not null default = 0
     */
    private Byte receiveType;

    /**
     * 用户名称 冗余 platform_user
     * max length = 100
     * not null default =
     */
    private String userName;

    /**
     * 头像 冗余 platform_user
     * max length = 300
     * not null default =
     */
    private String avatarUrl;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 是否新访客
     */
    private Byte first;

    /**
     * 领取失败原因
     */
    private String failReason;

    /**
     * 领取时间
     */
    private String grabDateStr;

}
