package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 开户申请
 * @author youqian mybatis generator 
 * 2020-10-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MerchantApplyDto implements Serializable {
    private static final long serialVersionUID = 16039554142198674L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 申请ID
     * not null default = 0
     */
    private Long merchantApplyId;

    /**
     * 商户名称
     * max length = 20
     * not null default = 
     */
    private String merchantName;

    /**
     * 客户名称
     * max length = 100
     * not null default = 
     */
    private String customerName;

    /**
     * 客户手机号码
     * max length = 30
     * not null default = 
     */
    private String customerMobile;

    /**
     * 省编码
     * max length = 2
     * not null default = 
     */
    private String provinceCode;

    /**
     * 市编码
     * max length = 4
     * not null default = 
     */
    private String cityCode;

    /**
     * 区编码
     * max length = 6
     * not null default = 
     */
    private String areaCode;

    /**
     * 完整地址
     */
    private String detailArea;

    /**
     * 开单销售商户ID
     * not null default = 0
     */
    private Long sellerMerchantId;

    /**
     * 开单销售员工ID
     * not null default = 0
     */
    private Long sellerEmployeeId;

    /**
     * 0-未开户/1-已开户
     * not null default = 0
     */
    private Byte applyStatus;

    /**
     * 开户时间
     */
    private Date openTime;

    /**
     * 开户后商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;
}