package com.youqian.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商品基本规格属性值表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class ShopGoodsSpecDto implements Serializable {
    private static final long serialVersionUID = 15918567972094517L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsSpecId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 商品id
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 规格属性名id
     * not null default = 0
     */
    private Long shopSpecParamId;

    /**
     * 规格属性值id
     * not null default = 0
     */
    private Long shopSpecValueId;

    /**
     * 是否sku 1是
     * not null default = 0
     */
    private Byte hasSku;

    /**
     * sku id
     * not null default = 0
     */
    private Long skuId;

    /**
     * 服装商场的特殊需求，只要颜色和尺寸
1代表颜色属性
2代表尺寸属性
0代表其他属性
     * not null default = 0
     */
    private Byte colorOrSize;

    /**
     * 商户号
     * not null default = 0
     */
    private Long merchantId;
}