package com.youqian.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 添加商户
 * @author xiachenhang
 */
@Data
public class AddMerchantRequest implements Serializable {
    private static final long serialVersionUID = -8037044879975439820L;
    /**
     * 商户名称
     */
    private String merchantName;
    /**
     * 商户简称
     */
    private String merchantNickName;
    /**
     * 省编号
     */
    private String provinceCode;
    /**
     * 市编号
     */
    private String cityCode;
    /**
     * 区编号
     */
    private String areaCode;
    /**
     * 名称
     */
    private String name;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 状态
     */
    private Byte status;

    /**
     * 页面模板类别id
     * not null default = 0
     */
    private Long pageCategoryId;

    /**
     * 服务期开始时间
     */
    @NotNull(message = "服务期开始时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date startDate;

    /**
     * 服务期结束时间
     */
    @NotNull(message = "服务期结束时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date expireDate;

    /**
     * 负责人用户ID
     */
    private Long ownerUserId;

    /**
     * 商品类别 1：一元商品  2：二元商品
     * not null default = 0
     */
    private Integer goodsType;

    /**
     * 销售员工ID
     */
    private Long sellerEmployeeId;
}
