package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/10/26
 * @description
 */
@Data
public class ModifyOrderRequest extends CreateOrderRequest implements Serializable {

    @Min(value = 1, message = "订单ID必须大于0")
    @NotNull(message = "订单ID不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

}
