package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PlatformUserResponse implements Serializable {
    private static final long          serialVersionUID = 3186043004985948552L;
    /**
     * 公司名
     */
    private              String        companyName;
    /**
     * 用户ID
     */
    private              Long          userId           = 0L;
    /**
     * 头像
     */
    private              String        avatarUrl;
    /**
     * 商户ID
     */
    private              Long          merchantId       = 0L;
    /**
     * 性别
     */
    private              Byte          gender;
    /**
     * 部门ID
     */
    private              Long          orgId;
    /**
     * 手机号码
     */
    private              String        mobile;
    /**
     * 昵称
     */
    private              String        nickname;
    /**
     * 正式姓名
     */
    private              String        userName;
    /**
     * 微信OpenId
     */
    private              String        openId;
    /**
     * 权限列表
     */
    private              List<Integer> roleList;
    /**
     * 是否存在店铺名片
     */
    private              Boolean       hasStoreCard = false;
    /**
     * 是否有编辑名片的权限
     */
    private              Boolean       isEditStore = false;
    /**
     * 是否开单的权限
     */
    private              Boolean       isCreateOrder = false;
    /**
     * 收藏统计
     */
    private             Integer          collectTotal;
    /**
     * 询价统计
     */
    private             Integer          enquiryTotal;
    /**
     * 是否授权过微信的基本信息
     */
    private             Boolean          hasWxInfo = false;
    /**
     * 请求的时间戳
     */
    private             Long             timeStamp;

    /**
     * 商户LOGO
     * max length = 100
     * not null default =
     */
    private String merchantLogo;
}
