/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class StreamUtils {
    public static <T, R> Map<R, T> listToMap(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.toMap(mapper, c -> c));
    }

    public static <T, R> List<R> mapList(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new ArrayList();
        }
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapSet(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashSet();
        }
        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    public static <T> int count(List<T> source, Predicate<? super T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return 0;
        }
        return (int)source.stream().filter(filter).count();
    }
}

