/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.enums;

import java.util.stream.Stream;

public enum ExcelTypeEnum {
    UNITARY_GOODS(1, "unitaryGoods", "\u4e00\u5143\u5546\u54c1"),
    DUALITY_GOODS(2, "dualityGoods", "\u4e8c\u5143\u5546\u54c1");

    private final Integer code;
    private final String type;
    private final String desc;

    private ExcelTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ExcelTypeEnum getByCode(Integer code) {
        return Stream.of(ExcelTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNITARY_GOODS);
    }

    public static ExcelTypeEnum getByType(String type) {
        return Stream.of(ExcelTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNITARY_GOODS);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

