package com.youqian.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

//{
//    "config_str" : "null\n", #配置字符串信息
//    "angle" : float, #输入图片的角度（顺时针旋转），［0， 90， 180，270］
//    "reg_num" : string, #注册号，没有识别出来时返回"FailInRecognition"
//    "name" : string, #公司名称，没有识别出来时返回"FailInRecognition"
//    "type" : string, #公司类型，没有识别出来时返回"FailInRecognition"
//    "person" : string, #公司法人，没有识别出来时返回"FailInRecognition"
//    "establish_date": string, #公司注册日期(例：证件上为"2014年04月16日"，算法返回"20140416")
//    "valid_period": string, #公司营业期限终止日期(例：证件上为"2014年04月16日至2034年04月15日"，算法返回"20340415")
//    #当前算法将日期格式统一为输出为"年月日"(如"20391130"),并将"长期"表示为"29991231"，若证件上没有营业期限，则默认其为"长期",返回"29991231"。
//    "address" : string, #公司地址，没有识别出来时返回"FailInRecognition"
//    "capital" : string, #注册资本，没有识别出来时返回"FailInRecognition"
//    "business": string, #经营范围，没有识别出来时返回"FailInRecognition"
//    "emblem" : string, #国徽位置［top,left,height,width］，没有识别出来时返回"FailInDetection"
//    "title" : string, #标题位置［top,left,height,width］，没有识别出来时返回"FailInDetection"
//    "stamp" : string, #印章位置［top,left,height,width］，没有识别出来时返回"FailInDetection"
//    "qrcode" : string, #二维码位置［top,left,height,width］，没有识别出来时返回"FailInDetection"
//    "success" : bool, #识别成功与否 true/false
//    "request_id": string
//}
@Getter
public enum AliLicenseParamEnum {
    regCode("regCode","reg_num"),
    name("name","name"),
    legalPerson("legalPerson","person"),
    establishDate("establishDate","establish_date"),
    registeredAssets("registeredAssets","capital"),
    address("address","address");

    private String code;
    private String type;

    public static Map params;

    static {
        params = new HashMap<>();
        for(AliLicenseParamEnum param:values()){
            params.put(param.getType(),param.getCode());
        }
    }

    AliLicenseParamEnum(String code, String type){
        this.code = code;
        this.type = type;
    }
}
