package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/11/3.
 */
@Getter
public enum ExcelTypeEnum {

    UNITARY_GOODS(1, "unitaryGoods", "一元商品"),

    DUALITY_GOODS(2, "dualityGoods", "二元商品");

    private final Integer code;

    private final String  type;

    private final String  desc;

    ExcelTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ExcelTypeEnum getByCode(Integer code) {
        return Stream.of(ExcelTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(UNITARY_GOODS);
    }

    public static ExcelTypeEnum getByType(String type) {
        return Stream.of(ExcelTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(UNITARY_GOODS);
    }
}