package com.youqian.api.enums.redpack;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 红包类型
 * Created by hong
 * time 2020/7/23.
 */
@Getter
public enum RedpackReceiveTypeEnum {

    LUCKY_KING((byte)2,"luckyKing","手气王"),
    ORDINARY((byte)1,"ordinary","普通红包");
    private final Byte code;

    private final String type;

    private final String desc;

    RedpackReceiveTypeEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static RedpackReceiveTypeEnum getByCode(Byte code) {
        return Stream.of(RedpackReceiveTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(ORDINARY);
    }

    public static RedpackReceiveTypeEnum getByType(String type) {
        return Stream.of(RedpackReceiveTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(ORDINARY);
    }
}

