package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 用户收货地址表
 * @author youqian mybatis generator
 * 2020-04-08
 */
@Data
public class OrderRemarkModifyRequest implements Serializable {
    private static final long serialVersionUID = 3905804449743079001L;

    @Min(value = 1, message = "订单ID不能小于0")
    @NotNull(message = "订单ID不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @NotNull(message = "备注不能为空")
    @ApiModelProperty(value = "订单备注", required = true)
    private String orderRemark;
}
