package com.youqian.api.request;

import com.youqian.api.constants.Constants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/1/16
 * @description
 */
@Data
public class UpdateCustomerAddressRequest implements Serializable {

    @NotNull(message = "业务主键ID不能为空")
    @Min(value = 1, message = "业务主键ID必须大于0")
    @ApiModelProperty(value = "业务主键ID", required = true)
    private Long customerAddressId;

    @NotNull(message = "地址类型不能为空")
    @Min(value = 1, message = "地址类型必须大于0")
    @ApiModelProperty(value = "地址类型，1-收货地址/2-提货地址", required = true)
    private Byte addressType;

    @ApiModelProperty(value = "收货人名称", required = true)
    private String receiverName;

    @Pattern(regexp = Constants.mobileReg, message = "手机号码必须为11位")
    @ApiModelProperty(value = "收货人手机号码", required = true)
    private String receiverMobile;

    @NotBlank(message = "收货/提货地址不能为空")
    @ApiModelProperty(value = "收货/提货地址", required = true)
    private String receiverAddress;

    @NotBlank(message = "省代码不能为空")
    @ApiModelProperty(value = "省", required = true)
    private String provinceCode;

    @NotBlank(message = "市代码不能为空")
    @ApiModelProperty(value = "市", required = true)
    private String cityCode;

    @NotBlank(message = "区代码不能为空")
    @ApiModelProperty(value = "区", required = true)
    private String areaCode;

    @NotBlank(message = "省市区不能为空")
    @ApiModelProperty(value = "省市区",required = true)
    private String shortAddress;
}
