package com.youqian.api.dto.employee;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 员工权限表
 * @author youqian mybatis generator 
 * 2020-08-18
 */
@Data
public class EmployeeRoleDto implements Serializable {
    private static final long serialVersionUID = 15977418310399297L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 业务唯一ID
     * not null default = 0
     */
    private Long employeeRoleId;

    /**
     * 员工ID
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 角色ID
     * not null default = 0
     */
    private Long roleId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 0-未删除/其他-已删除
     * not null default = 0
     */
    private Byte deleted;
}