package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户配置表
 * @author youqian mybatis generator 
 * 2020-10-22
 */
@Data
public class MerchantConfigDto implements Serializable {
    private static final long serialVersionUID = 16033305377485184L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 配置ID
     * not null default = 0
     */
    private Long merchantConfigId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 配置key
     * max length = 100
     * not null default = 
     */
    private String configKey;

    /**
     * 配置value
     * max length = 100
     * not null default = 
     */
    private String configValue;

    /**
     * 删除标志
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}