package com.youqian.api.dto.order;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 发货单
 * @author youqian mybatis generator 
 * 2020-08-20
 */
@Data
public class OrderDeliveryDto implements Serializable {
    private static final long serialVersionUID = 15979132831385120L;

    @ApiModelProperty("业务ID")
    private Long orderDeliveryId;

    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("开发货单用户ID")
    private Long userId;

    @ApiModelProperty("开发货单员工ID")
    private Long employeeId;

    @ApiModelProperty("发货类型，1-厂家发货/2-物流发货/3-买家自提")
    private Byte transType;

    @ApiModelProperty("发货状态, EnumDeliverGoods")
    private Byte deliverGoods;

    @ApiModelProperty("发货/装车/自提 时间")
    private Date deliveryTime;

    @ApiModelProperty("发货/装车/自提 操作人")
    private Long deliveryOperatorId;

    @ApiModelProperty("发货/装车/自提 照片留存")
    private String deliveryImage;

    @ApiModelProperty("物流单号")
    private String deliveryNo;

    @ApiModelProperty("签收/提货地址")
    private String receiverName;

    @ApiModelProperty("签收/提货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("签收/提货地址")
    private String receiverAddress;

    @ApiModelProperty("签收时间")
    private Date receiveTime;

    @ApiModelProperty("签收操作人")
    private Long receiveOperatorId;

    @ApiModelProperty("签收 照片留存")
    private String receiveImage;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;
}