package com.youqian.api.dto.order;

import com.youqian.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderPageDto extends PageRequest implements Serializable {

    private static final long serialVersionUID = 5570968457893120011L;

    @ApiModelProperty("订单状态")
    private List<Byte> orderStatus;

    @ApiModelProperty("客户ID/等同于customerId")
    private Long clientId;

    @ApiModelProperty("用户ID")
    private Long createUserId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("员工ID")
    private Long employeeId;

    @ApiModelProperty("客户手机号")
    private String customerMobile;

    @ApiModelProperty("发货状态")
    private List<Byte> deliverGoods;

    @ApiModelProperty("收款状态")
    private List<Byte> moneyReceiveType;
}
