package com.youqian.api.dto.printer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户打印机表
 * @author youqian mybatis generator 
 * 2020-11-04
 */
@Data
public class MerchantPrinterDto implements Serializable {
    private static final long serialVersionUID = 16044827828123902L;

    /**
     * 业务ID
     * not null default = 0
     */
    private Long merchantPrinterId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 打印机ID
     * not null default = 0
     */
    private Long printerId;

    /**
     * 打印机型号
     * max length = 100
     * not null default = 
     */
    private String printerModel;

    /**
     * 打印机类型，1-蓝牙/2-云打印机
     * not null default = 0
     */
    private Byte printerType;

    /**
     * 云打印机纸张类型，9-A4, 513-A4连续纸(24.1x27.96), 517-A4连续纸二等分(24.1x14), 521-A4连续纸三等分(21.6x9.32)
     * not null default = 0
     */
    private Integer printerPageSize;

    /**
     * (蓝牙打印机)纸张宽度mm,48/72/120
     * not null default = 0
     */
    private Integer printerPageWidth;

    /**
     * 订单打印列数
     * not null default = 0
     */
    private Integer printerOrderColumn;

    /**
     * 发货单打印列数
     * not null default = 0
     */
    private Integer printerDeliveryColumn;

    /**
     * 云打印机ID
     * max length = 100
     * not null default = 
     */
    private String printerDeviceId;

    /**
     * 云打印机密钥
     * max length = 100
     * not null default = 
     */
    private String printerDeviceKey;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}