package com.youqian.api.dto.statistics.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户订单统计表（月）
 * @author youqian mybatis generator 
 * 2020-09-22
 */
@Data
public class OrderMonthDto implements Serializable {
    private static final long serialVersionUID = 16007632482524688L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 月报ID
     * not null default = 0
     */
    private Long orderMonthId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 统计月份格式：202006
     * not null default = 0
     */
    private Integer reportMonth;

    /**
     * 开单数量
     * not null default = 0
     */
    private Integer openOrderCount;

    /**
     * 开单金额
     * not null default = 0.00
     */
    private BigDecimal openOrderMoney;

    /**
     * 发货数量
     * not null default = 0
     */
    private Integer deliveryCount;

    /**
     * 发货金额
     * not null default = 0.00
     */
    private BigDecimal deliveryMoney;

    /**
     * 回款/收款
     * not null default = 0.00
     */
    private BigDecimal moneyBack;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}