package com.youqian.api.dto.statistics.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户商品订单统计表（总）
 * @author youqian mybatis generator 
 * 2020-09-22
 */
@Data
public class OrderSkuStatisticsDto implements Serializable {
    private static final long serialVersionUID = 16007733542458123L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 月报ID
     * not null default = 0
     */
    private Long orderSkuStatisticsId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * SKU ID
     * not null default = 0
     */
    private Long skuId;

    /**
     * 开单数量
     * not null default = 0
     */
    private Integer openOrderCount;

    /**
     * 商品出售数量
     * not null default = 0
     */
    private Integer skuCount;

    /**
     * 商品出售总价
     * not null default = 0.00
     */
    private BigDecimal skuMoney;

    /**
     * 购买客户数量
     * not null default = 0
     */
    private Integer customerCount;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}