package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/3/27
 * @description
 */
@Getter
public enum EnumDeliverGoods {

    /**
     *
     */
    UNKNOWN((byte) -1, "未知"),
    NOT_SEND((byte) 0, "未发货"),
    SENDING((byte) 1, "发货中"),
    SENT((byte) 2, "已发货"),
    SIGNED((byte) 3, "已签收"),
    SELF_GET((byte) 4, "已自提"),



    ;

    EnumDeliverGoods(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static boolean isNotSend(Byte b) {
        return Objects.equals(NOT_SEND.getCode(), b);
    }

    public static boolean isSending(Byte b) {
        return Objects.equals(SENDING.getCode(), b);
    }

    public static boolean isSent(Byte b) {
        return Objects.equals(SENT.getCode(), b);
    }
}
