package com.youqian.api.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author tengtuox
 * @date 2020/10/21
 * @description 商户配置表Key
 */
@Getter
public enum EnumMerchantConfig {

    YUN_PRINT_DEVICE_ID(String.class, "", "云打印设备ID"),
    YUN_PRINT_DEVICE_KEY(String.class, "", "云打印设备密钥"),
    YUN_PRINT_PAGE_SIZE(Integer.class, EnumPageSize.A4.getCode(), "云打印打印纸张类型", "可选值：9-A4, 513-A4连续纸(24.1x27.96), 517-A4连续纸二等分(24.1x14), 521-A4连续纸三等分(21.6x9.32)"),
    PRINT_TYPE(Integer.class, EnumPrintType.BLUETOOTH.getCode(), "打印机类型", "可选值：1-蓝牙打印机, 2-云打印"),
    PRINT_PAGE_WIDTH(Integer.class, EnumPrintWidth._48MM.getWidth(), "(蓝牙打印机)打印机纸张宽度，单位mm", "可选值：48,72,120"),
    PRINT_ORDER_COLUMN(Integer.class, EnumPrintWidth._48MM.getOrderColumn(), "(蓝牙打印机)打印订单展示列数量", "可选值：4,6"),
    PRINT_DELIVERY_COLUMN(Integer.class, EnumPrintWidth._48MM.getDeliveryColumn(), "(蓝牙打印机)打印发货单展示列数量", "可选值：3,5"),
    ;

    EnumMerchantConfig(Class<?> type, Object defaultValue, String configName) {
        this.type = type;
        this.configName = configName;
        this.defaultValue = defaultValue;
    }

    EnumMerchantConfig(Class<?> type, Object defaultValue, String configName, String configDesc) {
        this.configDesc = configDesc;
        this.type = type;
        this.configName = configName;
        this.defaultValue = defaultValue;
    }

    private final Class<?> type;
    private final Object defaultValue;
    private final String configName;
    private String configDesc = "";

    @SuppressWarnings("unchecked")
    public <T> T defaultValue() {
        return (T) defaultValue;
    }

    @SuppressWarnings("unchecked")
    public <T> T toType(String s) {
        if (StringUtils.isBlank(s)) {
            return (T) s;
        }

        if (String.class.equals(type)) {
            return (T) s;
        }

        if (Integer.class.equals(type)) {
            int i = Integer.parseInt(s);
            return (T) new Integer(i);
        }

        return (T) s;
    }
}
