package com.youqian.api.enums;

import com.youqian.api.request.OrderEvent;
import lombok.Getter;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 订单事件类型
 * @see OrderEvent
 */
@Getter
public enum EnumOrderEvent {

    OPEN_ORDER((byte) 1, "开单"),
    CONFIRM((byte) 2, "确认"),
//    DELIVER_GOODS((byte) 3, "发货"),
    MONEY_BACK((byte) 4, "收款"),
    FINISH((byte) 5, "完成"),
    CANCEL((byte) 6, "订单取消"),
    ;

    /**
     * 事件码
     */
    private final Byte eventType;

    /**
     * 事件类型
     */
    private final String desc;

    EnumOrderEvent(Byte eventType, String desc) {
        this.eventType = eventType;
        this.desc = desc;
    }


}
