package com.youqian.api.enums;

import lombok.Getter;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/11/3
 * @description 打印页大小
 */
@Getter
public enum EnumPageSize {

    UNKNOWN(0, "未知"),
//    _16K(93, "16K"),
    A4(9, "A4"),
//    A5(11, "A5"),
//    A5_L(146, "A5长边"),
//    A6(70, "A6"),
    A4_241(513, "A4连续纸(24.1x27.96)"),
//    A4_216(515, "A4连续纸(21.6x28)"),
    A4_HALF_241(517, "A4连续纸二等分(24.1x14)"),
//    A4_HALF_216(519, "A4连续纸二等分(21.6x14)"),
    A4_THIRD_241(521, "A4连续纸三等分(21.6x9.32)"),
//    A4_THIRD_216(523, "A4连续纸三等分(21.6x9.3)"),
    ;

    EnumPageSize(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final int code;
    private final String msg;

    public static EnumPageSize getByCode(Integer code) {
        for (EnumPageSize e : EnumPageSize.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static EnumPageSize getByCode(String code) {
        int codeI = NumberUtils.toInt(code);

        for (EnumPageSize e : EnumPageSize.values()) {
            if (Objects.equals(e.getCode(), codeI)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
