package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/11/4
 * @description
 */
@Getter
public enum EnumPrintType {

    UNKNOWN((byte) 0, "未知"),
    BLUETOOTH((byte) 1, "蓝牙打印机"),
    YUN_PRINT((byte) 2, "云打印"),
    ;

    EnumPrintType(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumPrintType getByCode(Byte code) {
        for (EnumPrintType e : EnumPrintType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

}
