package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/9/16
 * @description
 */
@Getter
public enum EnumSearchType {

    UNKNOWN((byte) 0, "未知"),
    ORDER_NO((byte) 1, "订单编号"),
    BUYER_NAME((byte) 2, "买家姓名"),
    BUYER_ENT((byte) 3, "买家企业"),
    BUYER_MOBILE((byte) 4, "买家手机号"),
    BUYER_MOBILE_LAST((byte) 5, "买家手机号后四位"),
    RECEIVER_NAME((byte) 6, "收货人姓名"),
    RECEIVER_MOBILE((byte) 7, "收货人手机号"),
    RECEIVER_MOBILE_LAST((byte) 8, "收货人手机号后四位"),
    ;

    private final byte code;

    private final String desc;

    EnumSearchType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumSearchType getByCode(Byte code) {
        for (EnumSearchType e : EnumSearchType.values()) {
            if (Objects.equals(e.code, code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
