package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 送货类型
 */
@Getter
public enum EnumTransType {

    /**
     *
     */
    UNKNOWN((byte) 0, ""),
    Factory_Delivery((byte) 1, "卖家送货"),
    Logistics_Delivery((byte) 2, "物流发货"),
    Self_Get((byte) 3, "买家自提"),

    ;

    private final Byte code;

    /**
     * 送货描述
     */
    private final String desc;

    EnumTransType(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isSelfGet(Byte b) {
        return Objects.equals(Self_Get.getCode(), b);
    }

    public static boolean isFactoryDelivery(Byte b) {
        return Objects.equals(Factory_Delivery.getCode(), b);
    }

    public static boolean isLogisticsDelivery(Byte b) {
        return Objects.equals(Logistics_Delivery.getCode(), b);
    }

    public static EnumTransType getByCode(Byte b) {
        for (EnumTransType e : EnumTransType.values()) {
            if (Objects.equals(e.getCode(), b)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
