package com.youqian.api.params.merchant;

import com.youqian.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang.StringUtils;

import java.util.regex.Pattern;

/**
 * 客户列表请求参数
 * Created by hong
 * time 2020/3/31.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerListParam extends PageParam {
    private static final long    serialVersionUID = -3869532044217140433L;

    private static final Pattern PHONE_REG        = Pattern.compile("^[1]([3-9])[0-9]{9}$");

    /**
     * 排序方式,0-客户添加时间（默认）,1-代收金额,2-单量,3-交易金额,4-开单时间
     * @see com.youqian.api.enums.customer.SortPropertyEnum
     */
    private Integer sortBy = 0;

    /**
     * 排序类型,0-倒序,1-正序
     * @see com.youqian.api.enums.SortTypeEnum
     */
    private Integer sortType=0;

    /**
     * 模糊搜索，支持姓名和手机号
     */
    private String  searchKey;

    /**
     * 商户id
     */
    private Long    merchantId;

//    /**
//     * 搜索如果是名字的话赋值给此字段
//     */
//    private String  searchName;

    /**
     * 是否加载黑名单
     */
    private Byte  blacklist;

//    public void setSearchKey(String searchKey) {
//        if(StringUtils.isBlank(searchKey)){
//            return;
//        }
//        if(PHONE_REG.matcher(searchKey).matches()){
//            this.searchKey = searchKey;
//            return;
//        }
//        this.searchName = searchKey;
//    }
}
